% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationProfiling.R
\name{calcDBObservedMutations}
\alias{calcDBObservedMutations}
\title{Calculate observed numbers of mutations}
\usage{
calcDBObservedMutations(db, sequenceColumn = "SEQUENCE_IMGT",
  germlineColumn = "GERMLINE_IMGT_D_MASK", frequency = FALSE,
  regionDefinition = NULL, mutationDefinition = NULL, nproc = 1)
}
\arguments{
\item{db}{\code{data.frame} containing sequence data.}

\item{sequenceColumn}{\code{character} name of the column containing input 
sequences.}

\item{germlineColumn}{\code{character} name of the column containing 
the germline or reference sequence.}

\item{frequency}{\code{logical} indicating whether or not to calculate
mutation frequencies. Default is \code{FALSE}.}

\item{regionDefinition}{\link{RegionDefinition} object defining the regions
and boundaries of the Ig sequences. If NULL, mutations 
are counted for entire sequence.}

\item{mutationDefinition}{\link{MutationDefinition} object defining replacement
and silent mutation criteria. If \code{NULL} then 
replacement and silent are determined by exact 
amino acid identity.}

\item{nproc}{number of cores to distribute the operation over. If the 
cluster has already been set the call function with 
\code{nproc} = 0 to not reset or reinitialize. Default is 
\code{nproc} = 1.}
}
\value{
A modified \code{db} \code{data.frame} with observed mutation counts for each 
          sequence listed. The columns names are dynamically created based on the
          regions in the \code{regionDefinition}. For example, when using the
          \link{IMGT_V_NO_CDR3} definition, which defines positions for CDR and
          FWR, the following columns are added:
          \itemize{
            \item  \code{OBSERVED_CDR_R}:  number of replacement mutations in CDR1 and 
                                           CDR2 of the V-segment.
            \item  \code{OBSERVED_CDR_S}:  number of silent mutations in CDR1 and CDR2 
                                           of the V-segment.
            \item  \code{OBSERVED_FWR_R}:  number of replacement mutations in FWR1, 
                                           FWR2 and FWR3 of the V-segment.
            \item  \code{OBSERVED_FWR_S}:  number of silent mutations in FWR1, FWR2 and
                                           FWR3 of the V-segment.
          }
}
\description{
\code{calcDBObservedMutations} calculates the observed number of mutations for each 
sequence in the input \code{data.frame}.
}
\details{
Mutation count are determined by comparing the input sequences (in the column specified 
by \code{sequenceColumn}) to the germline sequence (in the column specified by 
\code{germlineColumn}). 

The mutations are binned as either replacement (R) or silent (S) across the different 
regions of the sequences as defined by \code{regionDefinition}. Typically, this would 
be the framework (FWR) and complementarity determining (CDR) regions of IMGT-gapped 
nucleotide sequences. Mutation counts are appended to the input \code{db} as 
additional columns.
}
\examples{
# Subset example data
db <- subset(InfluenzaDb, CPRIMER \%in\% c("IGHA","IGHM") & 
                          BARCODE \%in\% c("RL016","RL018","RL019","RL021"))

# Run calcDBObservedMutations()
db_new <- calcDBObservedMutations(db, sequenceColumn="SEQUENCE_IMGT",
                                  germlineColumn="GERMLINE_IMGT_D_MASK",
                                  frequency=TRUE,
                                  regionDefinition=IMGT_V_NO_CDR3,
                                  nproc=1)
                     
}
\seealso{
\link{calcObservedMutations} is called by this function to get the list of mutations 
in each sequence grouped by the \link{RegionDefinition}. 
See \link{IMGT_SCHEMES} for a set of predefined \link{RegionDefinition} objects.
See \link{calcDBExpectedMutations} for calculating expected mutation frequencies.
}

