% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mail_connector.R
\docType{class}
\name{RegLogEmayiliConnector}
\alias{RegLogEmayiliConnector}
\title{RegLogConnector for email sending via \code{emayili} package}
\description{
With the use of this object, RegLogServer can send emails
confirming the registration and containing code for password reset procedure.
}
\seealso{
Other mailConnectors: 
\code{\link{RegLogGmailrConnector}}
}
\concept{mailConnectors}
\section{Super class}{
\code{\link[shiny.reglog:RegLogConnector]{shiny.reglog::RegLogConnector}} -> \code{RegLogEmayiliConnector}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{mails}}{List containing default mail templates to use by default
mail handlers for register and password reset}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RegLogEmayiliConnector$new()}}
\item \href{#method-clone}{\code{RegLogEmayiliConnector$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="get_logs">}\href{../../shiny.reglog/html/RegLogConnector.html#method-get_logs}{\code{shiny.reglog::RegLogConnector$get_logs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="resume">}\href{../../shiny.reglog/html/RegLogConnector.html#method-resume}{\code{shiny.reglog::RegLogConnector$resume()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="suspend">}\href{../../shiny.reglog/html/RegLogConnector.html#method-suspend}{\code{shiny.reglog::RegLogConnector$suspend()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialization of the object. Creates smtp server for email
sending.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogEmayiliConnector$new(
  from,
  smtp,
  lang = "en",
  custom_txts = NULL,
  custom_handlers = NULL,
  custom_mails = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{Character containing content in \code{from} of the email.}

\item{\code{smtp}}{Object created by \code{emayili::server} or all its similiar
functions.}

\item{\code{lang}}{character specyfiyng which language to use for all texts
generated in the UI. Defaults to 'en' for English. Currently 'pl' for
Polish is also supported.}

\item{\code{custom_txts}}{named list containing character strings with custom
messages. Defaults to NULL, so all built-in strings will be used.}

\item{\code{custom_handlers}}{named list of custom handler functions. Custom handler
should take arguments: \code{self} and \code{private} - relating to the R6 object
and \code{message} of class \code{RegLogConnectorMessage}. It should return
return \code{RegLogConnectorMessage} object.}

\item{\code{custom_mails}}{named list containing character strings of the same
structure as elements in the \code{mails} field. Not all elements need to be
present.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
default mails are used by \code{register_mail} and \code{reset_pass_mail}
handlers. To change the mail used by these handlers you can pass character
strings to the \code{custom_mail} argument during initialization or append them
directly into this list.

They are stored (and should be passed accordingly) in a list of structure:
\itemize{
\item register
\itemize{
\item subject
\item body
}
\item resetPass
\itemize{
\item subject
\item body
}
\item credsEdit
\itemize{
\item subject
\item body
}
}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogEmayiliConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
