% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-storage-mssqlserver.R
\name{DataStorageMSSQLServer}
\alias{DataStorageMSSQLServer}
\title{Data storage class with MS SQL Server provider}
\description{
Implementation of the \code{\link{DataStorage}} R6 class to MS SQL Server backend using a
unified API for read/write operations. This provider requires a configured
and named \code{ODBC} driver to be set up on your system, for example, "\code{ODBC}
Driver 17 for SQL Server" or "\code{ODBC} Driver 18 for SQL Server".

Note that MS SQL Server support requires a subtly different database schema:
the \code{time} field is stored as a \code{DATETIME} rather than a \code{TIMESTAMP}.
}
\examples{
\dontrun{
data_storage <- DataStorageMSSQLServer$new(
  user = "sa",
  password = "my-Secr3t_Password",
  hostname = "localhost",
  port = 1433,
  dbname = "shiny_telemetry",
  driver = "ODBC Driver 18 for SQL Server",
  trust_server_certificate = "YES"
)

data_storage$insert("example", "test_event", "session1")
data_storage$insert("example", "input", "s1", list(id = "id1"))
data_storage$insert("example", "input", "s1", list(id = "id2", value = 32))

data_storage$insert(
  "example", "test_event_3_days_ago", "session1",
  time = lubridate::as_datetime(lubridate::today() - 3)
)

data_storage$read_event_data()
data_storage$read_event_data(Sys.Date() - 1, Sys.Date() + 1)
data_storage$close()
}
}
\section{Super classes}{
\code{\link[shiny.telemetry:DataStorage]{shiny.telemetry::DataStorage}} -> \code{\link[shiny.telemetry:DataStorageSQLFamily]{shiny.telemetry::DataStorageSQLFamily}} -> \code{DataStorageMSSQLServer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataStorageMSSQLServer-new}{\code{DataStorageMSSQLServer$new()}}
\item \href{#method-DataStorageMSSQLServer-clone}{\code{DataStorageMSSQLServer$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="close"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-close'><code>shiny.telemetry::DataStorage$close()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="insert"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-insert'><code>shiny.telemetry::DataStorage$insert()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="read_event_data"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-read_event_data'><code>shiny.telemetry::DataStorage$read_event_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorageMSSQLServer-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorageMSSQLServer-new}{}}}
\subsection{Method \code{new()}}{
Initialize the data storage class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorageMSSQLServer$new(
  username = NULL,
  password = NULL,
  hostname = "127.0.0.1",
  port = 1433,
  dbname = "shiny_telemetry",
  driver = "ODBC Driver 17 for SQL Server",
  trust_server_certificate = "NO"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{username}}{string with a MS SQL Server username.}

\item{\code{password}}{string with the password for the username.}

\item{\code{hostname}}{string with hostname of the MS SQL Server instance.}

\item{\code{port}}{numeric value with the port number of MS SQL Server instance.}

\item{\code{dbname}}{string with the name of the database in the MS SQL Server
instance.}

\item{\code{driver}}{string with the name of the \code{ODBC} driver class for MS SQL,
for example "\code{ODBC} Driver 17 for SQL Server".}

\item{\code{trust_server_certificate}}{string with "NO" or "YES", setting
whether or not to trust the server's certificate implicitly.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorageMSSQLServer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorageMSSQLServer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorageMSSQLServer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
