% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{addResourcePath}
\alias{addResourcePath}
\alias{resourcePaths}
\alias{removeResourcePath}
\title{Resource Publishing}
\usage{
addResourcePath(prefix, directoryPath)

resourcePaths()

removeResourcePath(prefix)
}
\arguments{
\item{prefix}{The URL prefix (without slashes). Valid characters are a-z,
A-Z, 0-9, hyphen, period, and underscore. For example, a value of 'foo'
means that any request paths that begin with '/foo' will be mapped to the
given directory.}

\item{directoryPath}{The directory that contains the static resources to be
served.}
}
\description{
Add, remove, or list directory of static resources to Shiny's web server,
with the given path prefix. Primarily intended for package authors to make
supporting JavaScript/CSS files available to their components.
}
\details{
Shiny provides two ways of serving static files (i.e., resources):
\enumerate{
\item Static files under the \verb{www/} directory are automatically made available
under a request path that begins with \code{/}.
\item \code{addResourcePath()} makes static files in a \code{directoryPath} available
under a request path that begins with \code{prefix}.
}

The second approach is primarily intended for package authors to make
supporting JavaScript/CSS files available to their components.

Tools for managing static resources published by Shiny's web server:
\itemize{
\item \code{addResourcePath()} adds a directory of static resources.
\item \code{resourcePaths()} lists the currently active resource mappings.
\item \code{removeResourcePath()} removes a directory of static resources.
}
}
\examples{
addResourcePath('datasets', system.file('data', package='datasets'))
resourcePaths()
removeResourcePath('datasets')
resourcePaths()

# make sure all resources are removed
lapply(names(resourcePaths()), removeResourcePath)
}
\seealso{
\code{\link[=singleton]{singleton()}}
}
