% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion.R
\name{accordionItem}
\alias{accordionItem}
\alias{addAccordionItem}
\title{Create accordion item}
\usage{
accordionItem(
  id,
  header,
  content,
  class = NULL,
  enroll_callback = TRUE,
  active = FALSE,
  header_class = NULL,
  content_class = NULL,
  ...
)

addAccordionItem(
  accordionId,
  accordionItem,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{Unique id of accordion item.}

\item{header}{Accordion item header.}

\item{content}{Accordion item content.}

\item{class}{Class passed to accordion container.}

\item{enroll_callback}{It `TRUE`, click action on header will enroll the accordion
item (and collapse the other existing ones).
See \link{accordionEnrollOnClick} to see how configure custom on-click enroll element.}

\item{active}{Should item be enrolled?}

\item{header_class}{Additional class passed to header container.}

\item{content_class}{Additional class passed to content container.}

\item{...}{Extra elements passed to accordion container (before the first accordion item).}

\item{accordionId}{Id of accordion component where item should be added.}

\item{accordionItem}{Accordion item to be added.}

\item{session}{Shiny Session object.}
}
\value{
Nested list of `shiny.tag` objects, defining accordion item - its header and content,
  or no return value in case of using `addAccordionItem` method.
}
\description{
`accordionItem` allows to create new accordion item that can be passed directly to `accordion`
constructor or added on the fly with `addAccordionItem`.
}
\examples{
if (interactive()) {
   library(shiny)
   ui <- fluidPage(
     actionButton("new", "New"),
     accordion(
       "acc",
       accordionItem("first", "Hello", "There", active = TRUE),
       accordionItem("second", "General", "Kenobi")
     )
   )
   server <- function(input, output, session) {}
   shinyApp(ui, server)

  # Accordion with custom styling of header and content (and dynamically added items).
  library(shiny)

  styled_item <- function(id, header_text, content_text, active = FALSE) {
    accordionItem(
      id, header_text, content_text, active = active,
      header_class = "acc-header", content_class = "acc-content"
    )
  }
  ui <- fluidPage(
    tags$head(tags$style(
      ".acc-header, .acc-content {border: 1px solid; border-radius: 5px;}"
    )),
    actionButton("new", "New"),
    accordion(
      "acc",
      styled_item("first", "Hello", "There", TRUE),
      styled_item("second", "General Kenobi", "There")
    )
  )
  server <- function(input, output, session) {
    observeEvent(input$new, {
      addAccordionItem(
        "acc",
        styled_item(
          sample(letters, 1), "I've Been Trained In Your Jedi Arts",
          "By Count Dooku", TRUE
        )
      )
    })
  }

  shinyApp(ui, server)
}

}
