% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_output.R
\name{panel_output}
\alias{panel_output}
\title{Panel output}
\usage{
panel_output(inputId, main_text, sub_text)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{main_text}{Add the header for the panel}

\item{sub_text}{Add the main body of text for the panel}
}
\value{
a panel html shiny object
}
\description{
This function inserts a panel.  Normally used for confirmation screens
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shinyGovstyle::gov_layout(size = "full",
      shinyGovstyle::panel_output(
        inputId = "panel1",
        main_text = "Application Complete",
        sub_text = "Thank you for submitting your application.
                    Your reference is xvsiq")
    ),
    shinyGovstyle::footer(full = TRUE)
  )

  server <- function(input, output, session) {}
  shinyApp(ui = ui, server = server)
}
}
\keyword{panel}
