% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typography.R
\name{f7Padding}
\alias{f7Padding}
\title{Create a Framework7 padding}
\usage{
f7Padding(tag, side = NULL)
}
\arguments{
\item{tag}{Tag to apply the padding.}

\item{side}{padding side: "left", "right", "top", "bottom",
"vertical" (top and bottom), "horizontal" (left and right).
Leave NULL to apply on all sides.}
}
\description{
Build a Framework7 padding
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 cardTag <- f7Card(
  title = "Card header",
  f7Padding(
   p("The padding is applied here.")
  ),
  footer = tagList(
    f7Button(color = "blue", label = "My button", src = "https://www.google.com"),
    f7Badge("Badge", color = "green")
  )
 )

 shiny::shinyApp(
   ui = f7Page(
    title = "Padding",
    f7SingleLayout(navbar = f7Navbar(title = "f7Padding"), cardTag)
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
