% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Grid.R
\name{f7Row}
\alias{f7Row}
\title{Create a Framework7 row container}
\usage{
f7Row(..., gap = TRUE)
}
\arguments{
\item{...}{Row content.}

\item{gap}{Whether to display gap between columns. TRUE by default.}
}
\description{
Build a Framework7 row container
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
  ui = f7Page(
    title = "Grid",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Row, f7Col"),
     f7Row(
     f7Col(
      f7Card(
       "This is a simple card with plain text,
       but cards can also contain their own header,
       footer, list view, image, or any other element."
      )
     ),
     f7Col(
      f7Card(
       title = "Card header",
       "This is a simple card with plain text,
        but cards can also contain their own header,
        footer, list view, image, or any other element.",
       footer = tagList(
        f7Button(color = "blue", "My button", src = "https://www.google.com"),
        f7Badge("Badge", color = "green")
       )
      )
     )
    )
    )
  ),
  server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
