% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Swiper.R
\name{f7Swiper}
\alias{f7Swiper}
\title{Create a Framework7 swiper}
\usage{
f7Swiper(
  ...,
  id,
  spaceBetween = 50,
  slidePerView = "auto",
  centered = TRUE,
  speed = 400
)
}
\arguments{
\item{...}{Slot for \link{f7Slide}.}

\item{id}{Swiper unique id.}

\item{spaceBetween}{Space between slides. 50 by default. Only if pagination is TRUE.}

\item{slidePerView}{Number of slides at a time. Only if pagination is TRUE. Set to "auto" by default.}

\item{centered}{Whether to center slides. Only if pagination is TRUE.}

\item{speed}{Slides speed. Numeric.}
}
\description{
Build a Framework7 swiper (like carousel)
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 timeline <- f7Timeline(
  sides = TRUE,
  f7TimelineItem(
   "Another text",
   date = "01 Dec",
   card = FALSE,
   time = "12:30",
   title = "Title",
   subtitle = "Subtitle",
   side = "left"
  ),
  f7TimelineItem(
   "Another text",
   date = "02 Dec",
   card = TRUE,
   time = "13:00",
   title = "Title",
   subtitle = "Subtitle"
  ),
  f7TimelineItem(
   "Another text",
   date = "03 Dec",
   card = FALSE,
   time = "14:45",
   title = "Title",
   subtitle = "Subtitle"
  )
 )

 shiny::shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Swiper"),
     f7Swiper(
     id = "my-swiper",
     f7Slide(
      timeline
     ),
     f7Slide(
      f7Toggle(
       inputId = "toggle",
       label = "My toggle",
       color = "pink",
       checked = TRUE
      ),
      verbatimTextOutput("test")
     )
    )
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint(input$toggle)
   }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
