% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Navbar.R
\name{f7SubNavbar}
\alias{f7SubNavbar}
\title{Framework7 sub navbar}
\usage{
f7SubNavbar(...)
}
\arguments{
\item{...}{Any elements.}
}
\description{
\code{f7SubNavbar} creates a nested navbar component for
\link{f7Navbar}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
     title = "Sub Navbar",
     f7TabLayout(
        panels = tagList(
         f7Panel(title = "Left Panel", side = "left", theme = "light", "Blabla", style = "cover"),
         f7Panel(title = "Right Panel", side = "right", theme = "dark", "Blabla", style = "cover")
        ),
        navbar = f7Navbar(
           title = "SubNavbar",
           hairline = FALSE,
           shadow = TRUE,
           leftPanel = TRUE,
           rightPanel = TRUE,
           subNavbar = f7SubNavbar(
              f7Button(label = "My button"),
              f7Button(label = "My button"),
              f7Button(label = "My button")
           )
        ),
        f7Tabs(
           animated = TRUE,
           #swipeable = TRUE,
           f7Tab(
              tabName = "Tab 1",
              icon = f7Icon("envelope"),
              active = TRUE,
              "Tab 1"
           ),
           f7Tab(
              tabName = "Tab 2",
              icon = f7Icon("today"),
              active = FALSE,
              "Tab 2"
           ),
           f7Tab(
              tabName = "Tab 3",
              icon = f7Icon("cloud_upload"),
              active = FALSE,
              "Tab 3"
           )
        )
     )
  ),
  server = function(input, output) {}
 )
}
}
