% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods__token.R
\name{introspect_token}
\alias{introspect_token}
\title{Introspect an OAuth 2.0 token}
\usage{
introspect_token(
  oauth_client,
  oauth_token,
  which = c("access", "refresh"),
  async = FALSE,
  shiny_session = NULL
)
}
\arguments{
\item{oauth_client}{\link{OAuthClient} object}

\item{oauth_token}{\link{OAuthToken} object to introspect}

\item{which}{Which token to introspect: "access" (default) or "refresh".}

\item{async}{Logical, default FALSE. If TRUE and promises is available, run
in background and return a promise resolving to the result list}

\item{shiny_session}{Optional pre-captured Shiny session context (from
\code{capture_shiny_session_context()}) to include in audit events. Used when
calling from async workers that lack access to the reactive domain.}
}
\value{
A list with fields: supported, active, raw, status
}
\description{
Introspects an access or refresh token using RFC 7662 when the
provider exposes an introspection endpoint. Returns a list including at least
\code{supported} (logical) and \code{active} (logical|NA) and the parsed response (if
any) under \code{raw}.

Authentication to the introspection endpoint mirrors the provider's
\code{token_auth_style}:
\itemize{
\item "header" (default): HTTP Basic with \code{client_id}/\code{client_secret}.
\item "body": form fields \code{client_id} and (when available) \code{client_secret}.
\item "client_secret_jwt" / "private_key_jwt": a signed JWT client assertion
is generated (RFC 7523) and sent via \code{client_assertion_type} and
\code{client_assertion}, with \code{aud} resolved via
\code{resolve_client_assertion_audience()} (so \code{client_assertion_audience}
overrides are honored).
}
}
\details{
Best-effort semantics:
\itemize{
\item If the provider does not expose an introspection endpoint, the function
returns \code{supported = FALSE}, \code{active = NA}, and \code{status = "introspection_unsupported"}.
\item If the endpoint responds with an HTTP error (e.g., 404/500) or the body
cannot be parsed or does not include a usable \code{active} field, the function
does not throw. It returns \code{supported = TRUE}, \code{active = NA}, and a
descriptive \code{status} (for example, \code{"http_404"}, \code{"invalid_json"},
\code{"missing_active"}). In this context, \code{NA}
means "unknown" and will not break flows unless your code explicitly
requires a definitive result (i.e., \code{isTRUE(result$active)}).
\item Providers vary in how they encode the RFC 7662 \code{active} field (logical,
numeric, or character variants like "true"/"false", 1/0). These are
normalized to logical \code{TRUE}/\code{FALSE} when possible; otherwise \code{active} is
set to \code{NA}.
}
}
\examples{
# Please note: `get_userinfo()`, `introspect_token()`, and `refresh_token()`
# are typically not called by users of this package directly, but are called
# internally by `oauth_module_server()`. These functions are exported
# nonetheless for advanced use cases. Most users will not need to
# call these functions directly

# Example requires a real token from a completed OAuth flow
# (code is therefore not run; would error with placeholder values below)
\dontrun{
# Define client
client <- oauth_client(
  provider = oauth_provider_github(),
  client_id = Sys.getenv("GITHUB_OAUTH_CLIENT_ID"),
  client_secret = Sys.getenv("GITHUB_OAUTH_CLIENT_SECRET"),
  redirect_uri = "http://127.0.0.1:8100"
)

# Have a valid OAuthToken object; fake example below
# (typically provided by `oauth_module_server()` or `handle_callback()`)
token <- handle_callback(client, "<code>", "<payload>", "<browser_token>")

# Get userinfo
user_info <- get_userinfo(client, token)

# Introspect token (if supported by provider)
introspection <- introspect_token(client, token)

# Refresh token
new_token <- refresh_token(client, token, introspect = TRUE)
}
}
