% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notify.R
\name{config_notify}
\alias{config_notify}
\title{Configure options for \code{\link[=notify]{notify()}} and others}
\usage{
config_notify(
  background = NULL,
  textColor = NULL,
  childClassName = NULL,
  notiflixIconColor = NULL,
  fontAwesomeClassName = NULL,
  fontAwesomeIconColor = NULL,
  backOverlayColor = NULL,
  width = NULL,
  distance = NULL,
  opacity = NULL,
  borderRadius = NULL,
  rtl = NULL,
  messageMaxLength = NULL,
  backOverlay = NULL,
  plainText = NULL,
  showOnlyTheLastOne = NULL,
  clickToClose = NULL,
  pauseOnHover = NULL,
  ID = NULL,
  className = NULL,
  zindex = NULL,
  fontFamily = NULL,
  fontSize = NULL,
  cssAnimation = NULL,
  cssAnimationDuration = NULL,
  cssAnimationStyle = NULL,
  closeButton = NULL,
  useIcon = NULL,
  useFontAwesome = NULL,
  fontAwesomeIconStyle = NULL,
  fontAwesomeIconSize = NULL,
  ...
)
}
\arguments{
\item{background}{Changes the background color.}

\item{textColor}{Changes the text color.}

\item{childClassName}{Changes the class name.}

\item{notiflixIconColor}{Changes the SVG icon color.}

\item{fontAwesomeClassName}{Changes the FontAwesome icon class name (FontAwesome has to be added to the project separately.)}

\item{fontAwesomeIconColor}{Changes the FontAwesome icon color.}

\item{backOverlayColor}{Changes the color of the background overlay.}

\item{width}{Changes the width of the notifications.}

\item{distance}{The distance between positioned notifications and the body element.}

\item{opacity}{Changes the opacity. (Between 0 and 1)}

\item{borderRadius}{Changes the radius of the notifications corners.}

\item{rtl}{Specifies the text direction to "right-to-left".}

\item{messageMaxLength}{The maximum length of the notifications message text.}

\item{backOverlay}{Adds a background overlay to the notifications.}

\item{plainText}{Strips all HTML tags.}

\item{showOnlyTheLastOne}{Auto-removes all the notifications except for the last one.}

\item{clickToClose}{Removes the notification when it has been clicked without waiting for the delay.}

\item{pauseOnHover}{Auto-remove functionality will be paused for each notification element when the pointer(mouse) enters on it.}

\item{ID}{Changes the ID (attribute) of the notifications.}

\item{className}{Changes the class name (attribute) of the notifications.}

\item{zindex}{Changes the z-index of the notifications.}

\item{fontFamily}{Changes the font-family of the notifications message text.}

\item{fontSize}{Changes the font-size of the notifications message text.}

\item{cssAnimation}{Enables/disables CSS animations to show/hide the notifications.}

\item{cssAnimationDuration}{Changes the CSS animations duration as milliseconds.}

\item{cssAnimationStyle}{6 types of styles can be used: fade zoom from-right from-top from-bottom from-left}

\item{closeButton}{Adds a close button/icon to the notifications. (Notifications with a close button won't disappear until they were clicked.)}

\item{useIcon}{Allows using built-in SVG or external FontAwesome icons in the notifications. (By default, built-in SVG icons have been defined.)}

\item{useFontAwesome}{Ignores built-in SVG icons and allows to use of external FontAwesome icons.}

\item{fontAwesomeIconStyle}{2 types of styles can be used: basic shadow}

\item{fontAwesomeIconSize}{Changes the font-size of the FontAwesome icons}

\item{...}{Other potential arguments.}
}
\value{
A config \code{list} that can be used in \code{\link[=notify]{notify()}} and other \verb{notify_*} functions.
}
\description{
Options for \code{\link[=notify]{notify()}} functions, see
\href{https://notiflix.github.io/documentation}{online documentation}
for default values and examples.
}
\examples{
library(shiny)
library(shinybusy)

ui <- fluidPage(
  tags$h2("config for notify examples"),
  actionButton("success", "Success")
)

server <- function(input, output, session) {

  observeEvent(input$success, {
    notify_success(
      "Well done!",
      config_notify(
        background = "#0431B4",
        notiflixIconColor = "#FFF"
      )
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
