% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dashboardSidebar.R
\name{sidebarMenu}
\alias{menuItem}
\alias{menuSubItem}
\alias{sidebarMenu}
\title{Create a dashboard sidebar menu and menu items.}
\usage{
sidebarMenu(..., id = NULL, .list = NULL)

menuItem(text, ..., icon = NULL, badgeLabel = NULL, badgeColor = "green",
  tabName = NULL, href = NULL, newtab = TRUE, selected = NULL)

menuSubItem(text, tabName = NULL, href = NULL, newtab = TRUE,
  icon = shiny::icon("angle-double-right"), selected = NULL)
}
\arguments{
\item{...}{For menu items, this may consist of \code{\link{menuSubItem}}s.}

\item{id}{For \code{sidebarMenu}, if \code{id} is present, this id will be
used for a Shiny input value, and it will report which tab is selected. For
example, if \code{id="tabs"}, then \code{input$tabs} will be the
\code{tabName} of the currently-selected tab.}

\item{.list}{An optional list containing items to put in the menu Same as the
  \code{...} arguments, but in list format. This can be useful when working
  with programmatically generated items.}

\item{text}{Text to show for the menu item.}

\item{icon}{An icon tag, created by \code{\link[shiny]{icon}}. If
\code{NULL}, don't display an icon.}

\item{badgeLabel}{A label for an optional badge. Usually a number or a short
word like "new".}

\item{badgeColor}{A color for the badge. Valid colors are listed in
\link{validColors}.}

\item{tabName}{The name of a tab that this menu item will activate. Not
compatible with \code{href}.}

\item{href}{An link address. Not compatible with \code{tabName}.}

\item{newtab}{If \code{href} is supplied, should the link open in a new
browser tab?}

\item{selected}{If \code{TRUE}, this \code{menuItem} or \code{menuSubItem}
will start selected. If no item have \code{selected=TRUE}, then the first
\code{menuItem} will start selected.}
}
\description{
A \code{dashboardSidebar} can contain a \code{sidebarMenu}. A
\code{sidebarMenu} contains \code{menuItem}s, and they can in turn contain
\code{menuSubItem}s.
}
\details{
Menu items (and similarly, sub-items) should have a value for either
\code{href} or \code{tabName}; otherwise the item would do nothing. If it has
a value for \code{href}, then the item will simply be a link to that value.

If a \code{menuItem} has a non-NULL \code{tabName}, then the \code{menuItem}
will behave like a tab -- in other words, clicking on the \code{menuItem}
will bring a corresponding \code{tabItem} to the front, similar to a
\code{\link[shiny]{tabPanel}}. One important difference between a
\code{menuItem} and a \code{tabPanel} is that, for a \code{menuItem}, you
must also supply a corresponding \code{tabItem} with the same value for
\code{tabName}, whereas for a \code{tabPanel}, no \code{tabName} is needed.
(This is because the structure of a \code{tabPanel} is such that the tab name
can be automatically generated.) Sub-items are also able to activate
\code{tabItem}s.

Menu items (but not sub-items) also may have an optional badge. A badge is a
colored oval containing text.
}
\seealso{
\code{\link{dashboardSidebar}} for example usage. For
  dynamically-generated sidebar menus, see \code{\link{renderMenu}} and
  \code{\link{sidebarMenuOutput}}.

Other sidebar items: \code{\link{sidebarSearchForm}};
  \code{\link{sidebarUserPanel}}
}

