% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{todoList}
\alias{todoList}
\title{AdminLTE2 todo list container}
\usage{
todoList(..., sortable = TRUE)
}
\arguments{
\item{...}{slot for todoListItem.}

\item{sortable}{Whether the list elements are sortable or not.}
}
\description{
Create a todo list container
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinyjqui)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      "Sortable todo list demo",
      status = "warning",
      todoList(
        todoListItem(
          label = "Design a nice theme",
          "Some text here"
        ),
        todoListItem(
          label = "Make the theme responsive",
          "Some text here"
        ),
        todoListItem(
          checked = TRUE,
          label = "Let theme shine like a star"
        )
       )
      ),
      box(
      "Simple todo list demo",
      status = "warning",
      todoList(
      sortable = FALSE,
        todoListItem(
          label = "Design a nice theme",
          "Some text here"
        ),
        todoListItem(
          label = "Make the theme responsive",
          "Some text here"
        ),
        todoListItem(
          checked = TRUE,
          label = "Let theme shine like a star"
        )
       )
      )
    ),
    title = "Todo Lists"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
