% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_module.R
\name{shiny_drive_ui}
\alias{shiny_drive_ui}
\alias{shiny_drive_server}
\title{File management shiny module.}
\usage{
shiny_drive_ui(id)

shiny_drive_server(
  input,
  output,
  session,
  id,
  save_dir,
  dir_access = NULL,
  admin_user = TRUE,
  force_desc = FALSE,
  lan = "EN",
  file_translate = read.csv(system.file("translate/translate.csv", package =
    "shinydrive"), sep = ";", encoding = "UTF-8", check.names = FALSE),
  datatable_options = list(),
  yml = "files_desc.yaml",
  date_time_format = "\%Y\%m\%d_\%H\%M\%s"
)
}
\arguments{
\item{id}{\code{character}. An ID string}

\item{input}{shiny input}

\item{output}{shiny input}

\item{session}{shiny input}

\item{save_dir}{\code{character/reactive}. Main directory of the files.}

\item{dir_access}{\code{character/reactive} vector for dir(s) access. Default to \code{NULL} (all directories)}

\item{admin_user}{\code{boolean/reactive} (TRUE). Admin user or not.}

\item{force_desc}{\code{boolean/reactive} (FALSE). Force to add an entry description ?}

\item{lan}{\code{character/reactive} ("EN"). Language to be used in the module (FR, EN and CN availabled... contributions are welcome :)).}

\item{file_translate}{\code{data.frame/reactive} File for translation.}

\item{datatable_options}{\code{list/reactive}.  \code{DT::datatable} options argument.}

\item{yml}{\code{characte/reactiver} yaml configuration file name.}

\item{date_time_format}{\code{character} DateTime format.}
}
\value{
Shiny module without return value.
}
\description{
File management shiny module.
}
\examples{
\dontrun{

if(require(shiny)){
  ui <- fluidPage(
    shiny_drive_ui(id = "idm")
  )
  server <- function(input, output, session) {
    callModule(module = shiny_drive_server,
             id = "idm",
             session = session,
             admin_user = TRUE,
             save_dir =  getwd(),
             lan = "FR")
  }
  shinyApp(ui, server)
}

}

}
