% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/useShinyjs.R
\name{useShinyjs}
\alias{useShinyjs}
\title{Set up a Shiny app to use shinyjs}
\usage{
useShinyjs()
}
\value{
Scripts that \code{shinyjs} requires that are automatically inserted
to the app's \code{<head>} tag.
}
\description{
This function must be called from a Shiny app's UI in order for all other
\code{shinyjs} functions to work.\cr\cr
You can call \code{useShinyjs()} from anywhere inside the UI.
}
\examples{
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      useShinyjs(),  # Set up shinyjs
      shiny::actionButton("btn", "Click me"),
      shiny::p(id = "element", "Watch what happens to me")
    ),
    server = function(input, output) {
      shiny::observe({
        if (input$btn == 0) {
          return(NULL)
        }
        # Run a simply shinyjs function
        toggle("element")
      })
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{runExample}}
\code{\link[shinyjs]{extendShinyjs}}
}

