% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{MRPWorkflow-method-outcome_map}
\alias{MRPWorkflow-method-outcome_map}
\alias{outcome_map}
\title{Visualize raw outcome measure by geography}
\usage{
outcome_map(summary_type = NULL, file = NULL)
}
\arguments{
\item{summary_type}{Character string, for time-varying data, indicating whether to display the
highest (\code{"max"}) or lowest (\code{"min"}) temporal average. Leave as \code{NULL} for cross-sectional data.}

\item{file}{Optional file path with .html extension to save the interactive map.
Expand the hamburger menu in the top right corner of the map to access other export options.}
}
\value{
A highcharter map object showing average outcome measure by geography.
}
\description{
The \verb{$outcome_map()} method creates maps showing the average outcome values
by geography for cross-sectional data, or the highest/lowest temporal average for time-varying data.
The sample and poststratification data must contain geographic information for this method to work.
Check out the \href{https://mrp-interface.github.io/shinymrp/articles/example#outcome_map}{More examples of R6 classes}
vignette for usage examples.
}
