% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-app.R
\name{testApp}
\alias{testApp}
\title{Run tests for a Shiny application}
\usage{
testApp(
  appDir = ".",
  testnames = NULL,
  quiet = FALSE,
  compareImages = TRUE,
  interactive = is_interactive(),
  suffix = NULL
)
}
\arguments{
\item{appDir}{Path to directory containing a Shiny app (e.g. \code{app.R}) or
single interactive \code{.Rmd}.}

\item{testnames}{Test script(s) to run. The .R extension of the filename is
optional. For example, \code{"mytest"} or \code{c("mytest", "mytest2.R")}.
If \code{NULL} (the default), all scripts in the tests/ directory will be
run.}

\item{quiet}{Should output be suppressed? This is useful for automated
testing.}

\item{compareImages}{Should screenshots be compared? It can be useful to set
this to \code{FALSE} when the expected results were taken on a different
platform from the one currently being used to test the application.}

\item{interactive}{If there are any differences between current results and
expected results, provide an interactive graphical viewer that shows the
changes and allows the user to accept or reject the changes.}

\item{suffix}{An optional suffix for the expected results directory. For
example, if the suffix is \code{"mac"}, the expected directory would be
\code{mytest-expected-mac}.}
}
\description{
Run tests for a Shiny application
}
\seealso{
\code{\link[=snapshotCompare]{snapshotCompare()}} and \code{\link[=snapshotUpdate]{snapshotUpdate()}} if
you want to compare or update snapshots after testing. In most cases, the
user is prompted to do these tasks interactively, but there are also times
where it is useful to call these functions from the console.
}
