% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shorts-S3.R
\name{confint.shorts_model}
\alias{confint.shorts_model}
\title{S3 method for providing confidence intervals for the \code{shorts_model}}
\usage{
\method{confint}{shorts_model}(object, ...)
}
\arguments{
\item{object}{\code{shorts_model} object}

\item{...}{Forwarded to generic \code{confint()} function}
}
\description{
S3 method for providing confidence intervals for the \code{shorts_model}
}
\examples{
\dontrun{
split_distances <- c(10, 20, 30, 40, 50)
split_times <- create_timing_gates_splits(
  gates = split_distances,
  MSS = 10,
  MAC = 9,
  FD = 0,
  TC = 0,
  noise = 0.01
)

# Simple model
simple_model <- model_timing_gates(split_distances, split_times)
confint(simple_model)
}
}
