% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doublesigmoidalFitFunctions.R
\name{doublesigmoidalFitFormula}
\alias{doublesigmoidalFitFormula}
\title{Double Sigmoidal Formula}
\usage{
doublesigmoidalFitFormula(x, finalAsymptoteIntensity, maximum, slope1,
  midPoint1, slope2, midPointDistance)
}
\arguments{
\item{x}{the "time" (time) column of the dataframe}

\item{finalAsymptoteIntensity}{represents the intensity value at infinite time.}

\item{maximum}{the maximum value that the sigmoidal function can reach.}

\item{slope1}{the slope of the sigmoidal function at the steppest point in the exponential phase of the viral production. i.e when the intensity is increasing.}

\item{midPoint1}{the x axis value of the steppest point in the function.}

\item{slope2}{the slope of the sigmoidal function at the steppest point in the lysis phase. i.e when the intensity is decreasing.}

\item{midPointDistance}{the distance between the time of steppest increase and steppest decrease in the intensity data. In other words the distance between the x axis values of arguments of slope1 and slope2.}
}
\value{
Returns the predicted intensities for the given time points with the double-sigmoidal fitted parameters for the double sigmoidal fit.
}
\description{
Calculates intensities using the double-sigmoidal model fit and the parameters (maximum, final asymptote intensity, slope1, midpoint1, slope2, and mid point distance).
}
\examples{
time=seq(3,24,0.1)

#simulate intensity data and add noise
noise_parameter=0.2
intensity_noise=stats::runif(n = length(time),min = 0,max = 1)*noise_parameter
intensity=doublesigmoidalFitFormula(time,
                                   finalAsymptoteIntensity=.3,
                                   maximum=4,
                                   slope1=1,
                                   midPoint1=7,
                                   slope2=1,
                                   midPointDistance=8)
intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizedInput = normalizeData(dataInput)
parameterVector<-doublesigmoidalFitFunction(normalizedInput,tryCounter=2)


#Check the results
if(parameterVector$isThisaFit){
 intensityTheoretical=
       doublesigmoidalFitFormula(
               time,
               finalAsymptoteIntensity=parameterVector$finalAsymptoteIntensity_Estimate,
               maximum=parameterVector$maximum_Estimate,
               slope1=parameterVector$slope1_Estimate,
               midPoint1=parameterVector$midPoint1_Estimate,
               slope2=parameterVector$slope2_Estimate,
               midPointDistance=parameterVector$midPointDistance_Estimate)

 comparisonData=cbind(dataInput,intensityTheoretical)

 require(ggplot2)
 ggplot(comparisonData)+
   geom_point(aes(x=time, y=intensity))+
   geom_line(aes(x=time,y=intensityTheoretical))+
   expand_limits(x = 0, y = 0)}

if(!parameterVector$isThisaFit){print(parameterVector)}


}

