% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readARS.R
\name{readARS}
\alias{readARS}
\title{Ingest ARS (Analysis Results Standard) metadata, produce ARD (Analysis Results Dataset) code for each output}
\usage{
readARS(JSON_ARS, output_path = tempdir(), adam_path = "")
}
\arguments{
\item{JSON_ARS}{A JSON file containing ARS metadata for a reporting event}

\item{output_path}{Path to store .R ARD scripts}

\item{adam_path}{Path to folder containing ADaM datasets, to be run in ARD program}
}
\value{
R programmes generating ARDs - one for each output specificied in the ARS JSON
}
\description{
Ingest JSON or xlsx ARS (Analysis Results Standard) metadata, and meta-programme R scripts
that could be run as-is to produce Analysis Results Datasets when ingesting ADaM
datasets
}
\examples{
# path to JSON file containing ARS metadata

json_path <- ARS_example("ARS_V1_Common_Safety_Displays.json")

# output path for R programs
output_dir = tempdir()

# folder containing ADaM datasets
adam_folder = tempdir()

# run function, write to temp directory
readARS(json_path, output_dir, adam_folder)


}
