% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{read-static}
\alias{read-static}
\alias{sg_read_nodes}
\alias{sg_read_edges}
\alias{sg_read_exec}
\title{Read}
\usage{
sg_read_nodes(sg, data, ..., delay)

sg_read_edges(sg, data, ..., delay)

sg_read_exec(sg, refresh = TRUE)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{data}{Data.frame (or list) of nodes or edges.}

\item{...}{Any column name, see details.}

\item{delay}{Column name containing delay in milliseconds.}

\item{refresh}{Whether to refresh the \code{\link{force}} layout.}
}
\description{
Read nodes and edges into your graph, with or without a delay.
}
\section{Functions}{

\itemize{
  \item{\code{sg_read_nodes} read nodes.}
  \item{\code{sg_read_edges} read edges.}
  \item{\code{sg_read_exec} send read nodes and edges to JavaScript front end.}
}
}

\examples{
nodes <- sg_make_nodes(50)
 nodes$batch <- c(
	 rep(1000, 25),
	 rep(3000, 25)
	)

edges <- data.frame(
 id = 1:80,
	 source = c(
	  sample(1:25, 40, replace = TRUE),
		sample(1:50, 40, replace = TRUE)
	 ),
	 target = c(
	  sample(1:25, 40, replace = TRUE),
		sample(1:50, 40, replace = TRUE)
	 ),
	 batch = c(
	  rep(1000, 40),
		rep(3000, 40)
	 )
) \%>\% 
 dplyr::mutate_all(as.character)

sigmajs() \%>\% 
  sg_force_start() \%>\% 
  sg_read_nodes(nodes, id, label, color, size, delay = batch) \%>\% 
  sg_read_edges(edges, id, source, target, delay = batch) \%>\% 
	 sg_force_stop(4000) \%>\% 
  sg_read_exec() \%>\% 
	 sg_button("read_exec", "Add nodes & edges")

}
