% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_series.R
\name{sig_estimate}
\alias{sig_estimate}
\title{Estimate signature number}
\usage{
sig_estimate(nmf_matrix, range = 2:5, nrun = 10, what = "all",
  cores = 1, seed = 123456, use_random = TRUE, save_plots = FALSE,
  plot_basename = file.path(tempdir(), "nmf"), method = "brunet",
  pConstant = NULL, verbose = FALSE)
}
\arguments{
\item{nmf_matrix}{a \code{matrix} used for NMF decomposition (with rownames and colnames),
generate from \link{sig_prepare} function.}

\item{range}{a \code{numeric} vector containing the ranks of factorization to try. Note that duplicates are removed and values are sorted in increasing order. The results are notably returned in this order.}

\item{nrun}{a \code{numeric} giving the number of run to perform for each value in \code{range}, \code{nrun} set to 30~50 is enough to achieve robust result.}

\item{what}{a character vector whose elements partially match one of the following item, which correspond to the measures computed by summary on each – multi-run – NMF result: ‘all’, ‘cophenetic’, ‘rss’, ‘residuals’, ‘dispersion’, ‘evar’, ‘silhouette’ (and more specific *.coef, *.basis, *.consensus), ‘sparseness’ (and more specific *.coef, *.basis). It specifies which measure must be plotted (what='all' plots all the measures).}

\item{cores}{number of cpu cores to run NMF.}

\item{seed}{specification of the starting point or seeding method, which will compute a starting point, usually using data from the target matrix in order to provide a good guess.}

\item{use_random}{Should generate random data from input to test measurements. Default is \code{TRUE}.}

\item{save_plots}{if \code{TRUE}, save plots to local machine.}

\item{plot_basename}{when save plots, set custom basename for file path.}

\item{method}{specification of the NMF algorithm. Use 'brunet' as default.
Available methods for nmf decompositions are 'brunet', 'lee', 'ls-nmf', 'nsNMF', 'offset'.}

\item{pConstant}{A small positive value to add to the matrix. Use it ONLY if the functions throws an \code{non-conformable arrays} error.}

\item{verbose}{if \code{TRUE}, print extra message.}
}
\value{
a \code{list} contains information of NMF run and rank survey.
}
\description{
Use \strong{NMF} package to evaluate the optimal number of signatures.
Users should \code{library(NMF)} firstly.
}
\details{
The most common approach is to choose the smallest rank for which cophenetic correlation coefficient
starts decreasing (Used by this function). Another approach is to choose the rank for which the plot
of the residual sum of squares (RSS) between the input matrix and its estimate shows an inflection point.
More custom features please directly use \link[NMF:nmfEstimateRank]{NMF::nmfEstimateRank}.
}
\examples{
\donttest{
# Load copy number prepare object
load(system.file("extdata", "toy_copynumber_prepare.RData",
  package = "sigminer", mustWork = TRUE
))
library(NMF)
cn_estimate <- sig_estimate(cn_prepare$nmf_matrix,
  cores = 1, nrun = 5,
  verbose = TRUE
)
}
}
\references{
Gaujoux, Renaud, and Cathal Seoighe. "A flexible R package for nonnegative matrix factorization." BMC bioinformatics 11.1 (2010): 367.
}
\seealso{
Other signature analysis series function: \code{\link{sig_assign_samples}},
  \code{\link{sig_extract}},
  \code{\link{sig_get_activity}},
  \code{\link{sig_get_correlation}},
  \code{\link{sig_get_similarity}},
  \code{\link{sig_prepare}},
  \code{\link{sig_summarize_subtypes}}
}
\author{
Shixiang Wang
}
\concept{signature analysis series function}
