% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_group_comparison.R
\name{show_group_comparison}
\alias{show_group_comparison}
\title{Plot Group Comparison Result}
\usage{
show_group_comparison(
  group_comparison,
  xlab = "group",
  ylab_co = NA,
  legend_title_ca = NA,
  legend_position_ca = "bottom",
  set_ca_sig_yaxis = FALSE,
  set_ca_custom_xlab = FALSE,
  show_pvalue = TRUE,
  ca_p_threshold = 0.01,
  method = "wilcox.test",
  p.adjust.method = "fdr",
  base_size = 12,
  font_size_x = 12,
  text_angle_x = 30,
  text_hjust_x = 0.2,
  ...
)
}
\arguments{
\item{group_comparison}{a \code{list} from result of \link{get_group_comparison} function.}

\item{xlab}{lab name of x axis for all plots. if it is \code{NA}, remove title for x axis.}

\item{ylab_co}{lab name of y axis for plots of continuous type data. Of note,
this argument should be a character vector has same length as \code{group_comparison},
the location for categorical type data should mark with \code{NA}.}

\item{legend_title_ca}{legend title for plots of categorical type data.}

\item{legend_position_ca}{legend position for plots of categorical type data.
Of note,
this argument should be a character vector has same length as \code{group_comparison},
the location for continuous type data should mark with \code{NA}.}

\item{set_ca_sig_yaxis}{if \code{TRUE}, use y axis to show signature proportion instead of
variable proportion.}

\item{set_ca_custom_xlab}{only works when \code{set_ca_sig_yaxis} is \code{TRUE}. If
\code{TRUE}, set x labels using input \code{xlab}, otherwise variable names will be used.}

\item{show_pvalue}{if \code{TRUE}, show p values.}

\item{ca_p_threshold}{a p threshold for categorical variables, default is 0.01.
A p value less than 0.01 will be shown as \code{P < 0.01}.}

\item{method}{a character string indicating which method to be used for comparing means.
It can be 't.test', 'wilcox.test' etc..}

\item{p.adjust.method}{correction method, default is 'fdr'. Run \code{p.adjust.methods} to
see all available options.}

\item{base_size}{overall font size.}

\item{font_size_x}{font size for x.}

\item{text_angle_x}{text angle for x.}

\item{text_hjust_x}{adjust x axis text}

\item{...}{other paramters pass to \code{\link[ggpubr:compare_means]{ggpubr::compare_means()}} or \code{\link[ggpubr:stat_compare_means]{ggpubr::stat_compare_means()}}
according to the specified \code{method}.}
}
\value{
a \code{list} of \code{ggplot} objects.
}
\description{
Using result data from \link{get_group_comparison}, this function plots
genotypes/phenotypes comparison between signature groups using \strong{ggplot2} package and return
a list of \code{ggplot} object contains individual and combined plots. The combined
plot is easily saved to local using \code{\link[cowplot:save_plot]{cowplot::save_plot()}}. Of note, default fisher
test p values are shown for categorical data and fdr values are shown for
continuous data.
}
\examples{
load(system.file("extdata", "toy_copynumber_signature_by_W.RData",
  package = "sigminer", mustWork = TRUE
))

# Assign samples to clusters
groups <- get_groups(sig, method = "k-means")

set.seed(1234)

groups$prob <- rnorm(10)
groups$new_group <- sample(c("1", "2", "3", "4", NA), size = nrow(groups), replace = TRUE)

# Compare groups (filter NAs for categorical coloumns)
groups.cmp <- get_group_comparison(groups[, -1],
  col_group = "group",
  cols_to_compare = c("prob", "new_group"),
  type = c("co", "ca"), verbose = TRUE
)

# Compare groups (Set NAs of categorical columns to 'Rest')
groups.cmp2 <- get_group_comparison(groups[, -1],
  col_group = "group",
  cols_to_compare = c("prob", "new_group"),
  type = c("co", "ca"), NAs = "Rest", verbose = TRUE
)

show_group_comparison(groups.cmp)

ggcomp <- show_group_comparison(groups.cmp2)
ggcomp$co_comb
ggcomp$ca_comb
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
