% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cn_freq_circos.R
\name{show_cn_freq_circos}
\alias{show_cn_freq_circos}
\title{Show Copy Number Variation Frequency Profile with Circos}
\usage{
show_cn_freq_circos(
  data,
  groups = NULL,
  cutoff = 2L,
  resolution_factor = 1L,
  title = c("AMP", "DEL"),
  chrs = paste0("chr", 1:22),
  genome_build = c("hg19", "hg38", "T2T", "mm10", "mm9", "ce11"),
  cols = NULL,
  plot_ideogram = TRUE,
  track_height = 0.5,
  ideogram_height = 1,
  ...
)
}
\arguments{
\item{data}{a \code{CopyNumber} object or a data.frame containing
at least 'chromosome', 'start', 'end', 'segVal', 'sample' these columns.}

\item{groups}{a named list or a column name for specifying groups.}

\item{cutoff}{copy number value cutoff for splitting data into AMP and DEL.
The values equal to cutoff are discarded. Default is \code{2}, you can also set
a length-2 vector, e.g. \code{c(2, 2)}.}

\item{resolution_factor}{an integer to control the resolution.
When it is \code{1} (default), compute frequency in each cytoband.
When it is \code{2}, use compute frequency in each half cytoband.}

\item{title}{length-2 titles for AMP and DEL.}

\item{chrs}{chromosomes start with 'chr'.}

\item{genome_build}{genome build version, used when \code{data} is a \code{data.frame}, should be 'hg19' or 'hg38'.}

\item{cols}{length-2 colors for AMP and DEL.}

\item{plot_ideogram}{default is \code{TRUE}, show ideogram.}

\item{track_height}{track height in \code{mm} unit.}

\item{ideogram_height}{ideogram height in \code{mm} unit.}

\item{...}{other parameters passing to \link[circlize:circos.genomicLines]{circlize::circos.genomicLines}.}
}
\value{
Nothing.
}
\description{
Show Copy Number Variation Frequency Profile with Circos
}
\examples{
\donttest{
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))

show_cn_freq_circos(cn)
ss <- unique(cn@data$sample)
show_cn_freq_circos(cn, groups = list(a = ss[1:5], b = ss[6:10]), cols = c("red", "green"))
}
}
