#' hsmm_pred_list class
#'
#' A list of prediction(s) generated by \code{\link{run_signal.hsmm}} function.
#'
#' @details A named list. Each element belongs to the \code{\link{hsmm_pred}} class.
#' @seealso \code{\link{summary.hsmm_pred_list}}, \code{\link{pred2df}}
#' @name hsmm_pred_list
NULL

#' Summarize list of signal.hsmm predictions
#'
#' Summarizes objects of class \code{\link{hsmm_pred_list}}.
#'
#' @param object of class \code{\link{hsmm_pred_list}}.
#' @param ... ignored
#' @return nothing.
#' @export
#' @keywords print methods manip

summary.hsmm_pred_list <- function(object, ...) {
  res <- pred2df(object)
  cat(paste0("Number of proteins tested: ", 
             nrow(res), "\n"))
  cat(paste0("Number of proteins with signal peptide: ", 
             sum(res[["sp.probability"]] > 0.5), "\n"))
  cat(paste0("Average length of predicted signal peptides: ", 
             signif(mean(res[res[["sp.probability"]] > 0.5, "sp.end"]), digits = 4), "\n"))
  cat(paste0("Median length of predicted signal peptides: ", 
             median(res[res[["sp.probability"]] > 0.5, "sp.end"]), "\n"))
}

#' Convert list of signal.hsmm predictions
#'
#' Converts objects of class \code{\link{hsmm_pred_list}} to data frame.
#'
#' @param object of class \code{\link{hsmm_pred_list}}.
#' @return Data frame which columns contain respectively the probability of signal
#' peptide presence as well as the start and the end of predicted signal peptide.
#' @export
#' @keywords manip

pred2df <- function(object) {
  do.call(rbind, lapply(object, function(i)
    data.frame(sp.probability = i[["sp_probability"]], 
               sp.start = i[["sp_start"]],
               sp.end = i[["sp_end"]])))
}