\name{makeGPS}
\alias{makeGPS}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Create your own Signature Object.
}
\description{
Given a repository of gene-pathway associations either in a tab
delimited file with three columns (pathwayID,pathway Description,Gene)
or a corresponding dataframe, this function identifies all Gene Pair
Signatures (pairs of genes that are as a combination unique to a single
pathway) and Pathway Unique Genes (genes that are uniquely associated
with a single pathway) and stores them in a format that is usable by
\code{sigora}.  Please also see the "details" and "note" sections below.
}
\usage{
makeGPS(pathwayTable=NULL,fn=NULL, maxLevels = 5, saveFile=NULL,
repoName = "userrepo", maxFunperGene = 100, maxGenesperPathway = 500,
minGenesperPathway = 10)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{pathwayTable}{
A data frame describing gene-pathway associations in following
format: pathwayID,pathwayName,Gene.
Either pathwayTable or fn should be provided.
}
  \item{fn}{
Where to find the repository.Either pathwayTable or fn should be provided.
}
  \item{maxLevels}{
For hierarchical repositories, the number of levels to consider.
}
  \item{saveFile}{
Where to save the object as an rda file.
}
  \item{repoName}{
Repository name.
}
  \item{maxFunperGene}{
 A cutoff threshold, genes with more than this number of associated
 pathways are excluded to speed up the GPS identification process.
}
  \item{maxGenesperPathway}{
A cutoff threshold, pathways with more than this number of associated
genes are excluded to speed up the GPS identification process.
}
  \item{minGenesperPathway}{
A cutoff threshold, pathways with less than this number of associated
genes are excluded to speed up the GPS identification process.
}
}
\details{
 The primary purpose of \code{makeGPS} is to convert a user-supplied
 gene-pathway  association table to a repository of weighted Gene Pair Signatures (GPS) that are unique features of pathways. Such GPS can than be used
 for signature (gene-pair) based analyses using \code{sigora}. 
Additionally, the  resulting object also retains the original
  "single gene"-"pathway" associations for the purpose of followup
  analyses, such as comparison of sigora-results to traditional
  methods. \code{ora} is an implementation of the traditional (individual gene) Overrepresentation Analysis. 
}
\value{
A GPS repository, to be used by \code{sigora} and \code{ora.}
}
\references{
Foroushani AB, Brinkman FS and Lynn DJ (2013).\dQuote{Pathway-GPS and SIGORA: identifying relevant pathways based on the over-representation of their gene-pair signatures.}\emph{PeerJ}, \bold{1}
}
\note{
This function relies on package \code{slam}, which should be installed
from CRAN.  It is fairly memory  intensive, and it is recommended to be
run on a machine with at least 6GB of RAM. Also, make sure to save and
reuse the resulting GPS repository in future analyses!
}

\seealso{
\code{\link{sigora}}, \code{\link{sigora-package}} 

}
\examples{
data(nciTable)
## what the input looks like:
head(nciTable)
## create a SigObject. use the saveFile parameter for reuse.  
nciH<-makeGPS(pathwayTable=nciTable)
ils<-grep("^IL",idmap[,"Symbol"],value=TRUE)
ilnci<-sigora(queryList=ils,GPSrepo=nciH,level=3)
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{functions}

