% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.simstatespace}
\alias{plot.simstatespace}
\title{Plot Method for an Object of Class \code{simstatespace}}
\usage{
\method{plot}{simstatespace}(x, id = NULL, time = NULL, eta = FALSE, type = "b", ...)
}
\arguments{
\item{x}{Object of class \code{simstatespace}.}

\item{id}{Numeric vector.
Optional \code{id} numbers to plot.
If \code{id = NULL}, plot all available data.}

\item{time}{Numeric vector.
Optional \code{time} points to plot.
If \code{time = NULL}, plot all available data.}

\item{eta}{Logical.
If \code{eta = TRUE}, plot the latent variables.
If \code{eta = FALSE}, plot the observed variables.}

\item{type}{Character indicating the type of plotting;
actually any of the types as in \code{\link[=plot.default]{plot.default()}}.}

\item{...}{Additional arguments.}
}
\description{
Plot Method for an Object of Class \code{simstatespace}
}
\examples{
# prepare parameters
set.seed(42)
k <- p <- 3
iden <- diag(k)
null_vec <- rep(x = 0, times = k)
n <- 5
mu0 <- null_vec
sigma0 <- iden
alpha <- null_vec
beta <- diag(x = 0.50, nrow = k)
psi <- iden
nu <- null_vec
lambda <- iden
theta <- diag(x = 0.50, nrow = k)
time <- 50
burn_in <- 0
gamma_y <- gamma_eta <- 0.10 * diag(k)
x <- lapply(
  X = seq_len(n),
  FUN = function(i) {
    return(
      matrix(
        data = rnorm(n = k * (time + burn_in)),
        ncol = k
      )
    )
  }
)

# Type 0
ssm <- SimSSMFixed(
  n = n,
  mu0 = mu0,
  sigma0 = sigma0,
  alpha = alpha,
  beta = beta,
  psi = psi,
  nu = nu,
  lambda = lambda,
  theta = theta,
  type = 0,
  time = time,
  burn_in = burn_in
)

plot(ssm)
plot(ssm, id = 1:3, time = 1:10)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
