% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_simaerep.R
\name{simaerep}
\alias{simaerep}
\title{Create simaerep object}
\usage{
simaerep(
  df_visit,
  r = 1000,
  check = TRUE,
  under_only = TRUE,
  visit_med75 = TRUE,
  inframe = FALSE,
  progress = TRUE,
  mult_corr = TRUE,
  param_site_aggr = list(method = "med75_adj", min_pat_pool = 0.2),
  param_sim_sites = list(r = 1000, poisson_test = FALSE, prob_lower = TRUE),
  param_eval_sites = list(method = "BH"),
  env = parent.frame(),
  event_names = c("ae")
)
}
\arguments{
\item{df_visit}{Data frame with columns: study_id, site_number, patnum, visit,
n_ae.}

\item{r}{Integer or tbl_object, number of repetitions for bootstrap
simulation. Pass a tbl object referring to a table with one column and as
many rows as desired repetitions. Default: 1000.}

\item{check}{Logical, perform data check and attempt repair with
\code{\link[=check_df_visit]{check_df_visit()}}. Computationally expensive on large data sets. Default:
TRUE.}

\item{under_only}{Logical, compute under-reporting probabilities only.
Supersedes under_only parameter passed to \code{\link[=eval_sites]{eval_sites()}} and \code{\link[=sim_sites]{sim_sites()}}.
Default: TRUE.}

\item{visit_med75}{Logical, should evaluation point visit_med75 be used.
Default: TRUE.}

\item{inframe}{Logical, only table operations to be used; does not require
visit_med75. Compatible with dbplyr supported database backends.}

\item{progress}{Logical, display progress bar. Default: TRUE.}

\item{mult_corr}{Logical, multiplicity correction, Default: TRUE}

\item{param_site_aggr}{List of parameters passed to \code{\link[=site_aggr]{site_aggr()}}. Default:
list(method = "med75_adj", min_pat_pool = 0.2).}

\item{param_sim_sites}{List of parameters passed to \code{\link[=sim_sites]{sim_sites()}}. Default:
list(r = 1000, poisson_test = FALSE, prob_lower = TRUE).}

\item{param_eval_sites}{List of parameters passed to \code{\link[=eval_sites]{eval_sites()}}. Default:
list(method = "BH").}

\item{env}{Optional, provide environment of original visit data. Default:
parent.frame().}

\item{event_names}{vector, contains the event names, default = "ae"}
}
\value{
A simaerep object.
}
\description{
Simulate AE under-reporting probabilities.
}
\details{
Executes \code{\link[=site_aggr]{site_aggr()}}, \code{\link[=sim_sites]{sim_sites()}}, and \code{\link[=eval_sites]{eval_sites()}} on original
visit data and stores all intermediate results. Stores lazy reference to
original visit data for facilitated plotting using generic plot(x).
}
\examples{
df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  frac_site_with_ur = 0.4,
  ur_rate = 0.6
)
df_visit$study_id <- "A"
aerep <- simaerep(df_visit)
aerep
str(aerep)


df_visit_events_test <- sim_test_data_events(n_pat = 100, n_sites = 5,
                                 ae_per_visit_mean = c(0.4, 0.5), event_names = c("ae", "pd"))
aerep_events <- simaerep(df_visit_events_test, inframe = TRUE,event_names = c("ae", "pd"))
aerep_events
\donttest{
  # In-frame table operations
  simaerep(df_visit, inframe = TRUE, visit_med75 = FALSE, under_only = FALSE)$df_eval
  simaerep(df_visit, inframe = TRUE, visit_med75 = TRUE, under_only = FALSE)$df_eval
  # Database example
  con <- DBI::dbConnect(duckdb::duckdb(), dbdir = ":memory:")
  df_r <- tibble::tibble(rep = seq(1, 1000))
  dplyr::copy_to(con, df_visit, "visit")
  dplyr::copy_to(con, df_r, "r")
  tbl_visit <- dplyr::tbl(con, "visit")
  tbl_r <- dplyr::tbl(con, "r")
  simaerep(tbl_visit, r = tbl_r, inframe = TRUE, visit_med75 = FALSE, under_only = FALSE)$df_eval
  simaerep(tbl_visit, r = tbl_r, inframe = TRUE, visit_med75 = TRUE, under_only = FALSE)$df_eval
  DBI::dbDisconnect(con)
}
}
\seealso{
\code{\link[=site_aggr]{site_aggr()}}, \code{\link[=sim_sites]{sim_sites()}}, \code{\link[=eval_sites]{eval_sites()}}, \code{\link[=orivisit]{orivisit()}},
\code{\link[=plot.simaerep]{plot.simaerep()}}

\link[=site_aggr]{site_aggr()}, \link[=sim_sites]{sim_sites()},
\link[=eval_sites]{eval_sites()}, \link[=orivisit]{orivisit()},
\link[=plot.simaerep]{plot.simaerep()}
}
