\name{SimCoImport}
\alias{SimCoImport}
\title{ A function to import Structure output files from either the current working directory or from a directory of choice }
\description{This program imports Structure output files and turns them into a useable dataframe for use in R. Particularly for use by the \code{"SimCoef()"} function of this package}
\usage{
SimCoImport(FILES)
}
\arguments{
\item{FILES}{This is a list of the Structure files to be imported.}
}
\details{The list of files is easily generated by putting the files in a directory, using \code{"setwd()"} to change the working directory to that directory and then \code{"list.files()"} to get the list.\cr
The best way to use this command is by first setting your working directory to one containing the sample files using \code{"setwd()"}.\cr
Examples of structure output files, and further help, are provided in the \code{docs} directory of the \code{simco} package (which should be in your R library folder if you have installed \code{simco} correctly.

For example:\cr

\code{setwd("/Users/orj/Documents/Simco/structurefiles")}\cr
\code{myfiles<-list.files()}\cr
\code{x<-SimCoImport(myfiles)}\cr
\code{x}}

\value{The output is a dataframe with columns of the confidence of assignment to a group and a run identifier (a CAPITAL letter). Rows are individual observations/samples.}
\references{
Rebbeck, CA, Jones, OR, & Tsai, IJ  (unpublished) SimCo: A program to automate the comparison of multiple structure runs (available from \email{owen.jones@imperial.ac.uk})

Pritchard, J. K. et al. (2000) Inference of population structure using multilocus genotype data. \emph{Genetics}. 155, 945-959.
}
\author{ Owen Jones }
\note{  }

\seealso{ \code{\link{SimCoef}} }
\examples{


}
\keyword{package}