% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cross.R
\name{plot_ind}
\alias{plot_ind}
\title{Plot an individual}
\usage{
plot_ind(
  ind,
  center,
  chrlength = 30,
  chrwidth = 3,
  gap = 3,
  col = CCcolors(),
  border = "black",
  lend = 1,
  ljoin = 1,
  allborders = FALSE,
  ...
)
}
\arguments{
\item{ind}{An individual object, as output by
\code{\link[=create_parent]{create_parent()}} or \code{\link[=cross]{cross()}}}

\item{center}{(x,y) vector for the center of the individual}

\item{chrlength}{Length of chromosomes (Can be a vector of length
2, in which case the two chromosomes will be different lengths,
aligned at the top. This is for the X chromosome.)}

\item{chrwidth}{Width of chromosomes}

\item{gap}{Gap between chromosomes}

\item{col}{Vector of colors}

\item{border}{Color for border}

\item{lend}{Passed to \code{\link[graphics:rect]{graphics::rect()}}}

\item{ljoin}{Passed to \code{\link[graphics:rect]{graphics::rect()}}}

\item{allborders}{If TRUE, put borders around all segments}

\item{...}{Additional arguments passed to rect()}
}
\value{
None.
}
\description{
Add an individual, as a pair of chromosomes, to a plot
}
\examples{
\dontshow{set.seed(67452378)}
mom <- create_parent(100, 1:2)
dad <- create_parent(100, 3:4)
kid <- cross(mom, dad)
plot(0,0, type="n", xlim=c(0, 100), ylim=c(0,100),
     xaxt="n", yaxt="n", xlab="", ylab="")
loc <- list(c(25,75), c(75,75), c(50,25))
plot_ind(mom, loc[[1]])
plot_ind(dad, loc[[2]])
plot_ind(kid, loc[[3]])
plot_crosslines(loc[[1]], loc[[2]], loc[[3]])
}
\seealso{
\code{\link[=plot_crosslines]{plot_crosslines()}}
}
\keyword{hplot}
