% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_api.R
\name{make_kernel_dist}
\alias{make_kernel_dist}
\title{Calculate 1D, 2D, or 3D kernel smooth distribution}
\usage{
make_kernel_dist(output, var_names, lims, kde_fun, n, h, adjust)
}
\arguments{
\item{output}{A matrix of simulation output.}

\item{var_names}{The names of the target variables.}

\item{lims}{The limits of the range for the density estimator as \code{c(xl, xu)} for 2D landscapes, \code{c(xl, xu, yl, yu)} for 3D landscapes, \code{c(xl, xu, yl, yu, zl, zu)} for 4D landscapes. If missing, the range of the data extended by 10\% for both sides will be used. For landscapes based on multiple simulations, the largest range of all simulations (which means the lowest lower limit and the highest upper limit) will be used by default.}

\item{kde_fun}{Which kernel estimator to use? Choices: "ks" \code{\link[ks:kde]{ks::kde()}} (default; faster and using less memory); "base" \code{base::density()} (only for 2D landscapes); "MASS" \code{\link[MASS:kde2d]{MASS::kde2d()}} (only for 3D landscapes).}

\item{n}{The number of equally spaced points in each axis, at which the density is to be estimated.}

\item{h}{A number, or possibly a vector for 3D and 4D landscapes, specifying the smoothing bandwidth to be used. If missing, the default value of the kernel estimator will be used (but \code{bw = "SJ"} for \code{base::density()}). Note that the definition of bandwidth might be different for different kernel estimators. For landscapes based on multiple simulations, the largest \code{h} of all simulations will be used by default.}

\item{adjust}{The multiplier to the bandwidth. The bandwidth used is actually \code{adjust * h}. This makes it easy to specify values like "half the default" bandwidth.}

\item{Umax}{The maximum displayed value of potential.}
}
\value{
A list of the smooth distribution.
}
\description{
Calculate 1D, 2D, or 3D kernel smooth distribution
}
\keyword{internal}
