% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessories.R
\name{splitDiffFeatureGroups}
\alias{splitDiffFeatureGroups}
\title{Split differential featureGroups}
\usage{
splitDiffFeatureGroups(diffFeatureGroups, checkValid = TRUE)
}
\arguments{
\item{diffFeatureGroups}{\code{data.frame} with optional columns \code{meanBase},
\code{dBase}, \code{meanSd}, \code{dSd}, \code{meanAmp}, \code{dAmp}, \code{meanPhase}, and \code{dPhase}
describing the changes in abundance between two conditions. Each row
corresponds to a group of features.}

\item{checkValid}{Logical for whether to only return rows for which both
amplitudes are greater than or equal to zero and both standard deviations
are greater than zero.}
}
\value{
List of two \code{data.table}s with possible columns \code{base}, \code{sd}, \code{amp},
and \code{phase}, depending on the columns in \code{diffFeatureGroups}.
}
\description{
Split a diffFeatureGroups data.frame into a list of two featureGroups
data.frames, which can then be passed to \code{\link[=simphony]{simphony()}}.
}
\examples{
dGroups = data.frame(meanAmp = c(1, 1, 1, 1), dAmp = c(1, 1, 2, 2),
                     meanPhase = c(0, 0, 0, 0), dPhase = c(0, 3, 0, 3))
featureGroups = splitDiffFeatureGroups(dGroups)

}
\seealso{
\code{\link[=simphony]{simphony()}}
}
