% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_stars_fun.R
\name{leaflet_stars}
\alias{leaflet_stars}
\title{Map of an array in leaflet.}
\usage{
leaflet_stars(data, pal = NULL, opacity = 0.5, title = "[Title]",
  legend_digits = 1, legend_labels = "[Array]", basemap = "light",
  shiny = FALSE, map_id = "map")
}
\arguments{
\item{data}{A stars object with dimensions x and y with crs in wgs84 (epsg4326). Required input.}

\item{pal}{Character vector of hex codes, or provided objects with pal_ prefixes.}

\item{opacity}{Sets the opacity of the grid cells. Defaults to 0.1.}

\item{title}{A title string that will be wrapped into the legend. Defaults to "Title".}

\item{legend_digits}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{legend_labels}{A vector of legend label values. Defaults to "[Array]".}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{shiny}{TRUE or FALSE for whether the map is being run within a shiny app. Defaults to FALSE.}

\item{map_id}{This argument is only relevant for within apps. For single map shiny apps, the id "map" can be used. For dual map apps, "map1" and "map2" should be used. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of an array in leaflet.
}
\examples{
leaflet_stars(example_stars_nz_no3n)
}
