% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_box_fun.R
\name{ggplot_box}
\alias{ggplot_box}
\title{Vertical box ggplot.}
\usage{
ggplot_box(data, x_var, y_var = NULL, stat = "boxplot",
  x_scale_labels = waiver(), y_scale_zero = TRUE,
  y_scale_zero_line = TRUE, y_scale_trans = "identity",
  y_scale_labels = waiver(), pal = NULL, title = "[Title]",
  subtitle = NULL, x_title = "[X title]", y_title = "[Y title]",
  caption = NULL, font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, wrap_title = 70, wrap_subtitle = 80,
  wrap_x_title = 50, wrap_y_title = 50, wrap_caption = 80,
  isMobile = FALSE)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted categorical variable to be on the x axis. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y axis. Defaults to NULL. Required if stat equals "boxplot".}

\item{stat}{String of "boxplot" or "identity". Defaults to "boxplot". If identity is selected, data provided must be grouped by the x_var with ymin, lower, middle, upper, ymax variables. Note "identity" does not provide outliers.}

\item{x_scale_labels}{Argument to adjust the format of the x scale labels.}

\item{y_scale_zero}{TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_scale_zero_line}{TRUE or FALSE whether to add a zero line in for when values are above and below zero. Defaults to TRUE.}

\item{y_scale_trans}{TRUEransformation of y-axis scale (e.g. "signed_sqrt"). Defaults to "identity", which has no transformation.}

\item{y_scale_labels}{Argument to adjust the format of the y scale labels.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{x_title}{X axis title string. Defaults to "[X title]".}

\item{y_title}{Y axis title string. Defaults to "[Y title]".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_x_title}{Number of characters to wrap the x title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_y_title}{Number of characters to wrap the y title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shinyapp, isMobile should be specified as input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Vertical box ggplot that is not coloured and not facetted.
}
\examples{
plot_data <- iris \%>\%
tibble::as_tibble() \%>\%
  dplyr::mutate(Species = stringr::str_to_sentence(Species))

plot <- ggplot_box(data = plot_data, x_var = Species, y_var = Petal.Length,
                    title = "Iris petal length by species",
                    x_title = "Species",
                    y_title = "Petal length (cm)")

plot

plotly::ggplotly(plot, tooltip = "text")

plot_data <- iris \%>\%
  dplyr::group_by(Species) \%>\%
  dplyr::summarise(boxplot_stats = list(rlang::set_names(boxplot.stats(Petal.Length)$stats,
  c('ymin','lower','middle','upper','ymax')))) \%>\%
  tidyr::unnest_wider(boxplot_stats)

ggplot_box(data = plot_data, x_var = Species, y_var = Petal.Length, stat = "identity")
}
