% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{na_status}
\alias{na_status}
\title{Show the number of (remaining) missing values.}
\usage{
na_status(
  x,
  show_only_missing = TRUE,
  sort_columns = show_only_missing,
  show_message = TRUE,
  ...
)
}
\arguments{
\item{x}{an R object caryying data (e.g. \code{data.frame})}

\item{show_only_missing}{if \code{TRUE} only columns with \code{NA}'s will be
printed.}

\item{sort_columns}{If \code{TRUE} the columns are sorted descending 
by the number of missing values.}

\item{show_message}{if \code{TRUE} message will be printed.}

\item{...}{arguments to be passed to other methods.}
}
\value{
\code{data.frame} with the column and number of NA's
}
\description{
Quick indication of the amount and location of missing values.
}
\examples{
irisNA <- iris
irisNA[1:3,1] <- irisNA[3:7,2] <- NA
na_status(irisNA)

# impute a constant 
a <- impute_const(irisNA, Sepal.Width ~ 7)
na_status(a)
}
\seealso{
\code{\link{glimpse_na}}
}
