% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_data_by_date.R
\name{cut_data_by_date}
\alias{cut_data_by_date}
\title{Cut a dataset for analysis at a specified date}
\usage{
cut_data_by_date(x, cut_date)
}
\arguments{
\item{x}{A time-to-event dataset, for example, generated by \code{\link[=sim_pw_surv]{sim_pw_surv()}}.}

\item{cut_date}{Date relative to start of randomization
(\code{cte} from input dataset) at which dataset is to be cut off for analysis.}
}
\value{
A data frame ready for survival analysis, including columns time to
event (\code{tte}), \code{event}, the \code{stratum}, and the \code{treatment}. The class of
the data frame is \code{tte_data}, and the attribute \code{ratio} generated by
\code{\link[=sim_pw_surv]{sim_pw_surv()}} is also attached.
}
\description{
Cut a dataset for analysis at a specified date
}
\examples{
# Use default enrollment and event rates and
# cut at calendar time 5 after start of randomization
sim_pw_surv(n = 20) |> cut_data_by_date(5)
}
