% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmwm.r
\name{gmwm_imu}
\alias{gmwm_imu}
\title{GMWM for (Robust) Inertial Measurement Units (IMUs)}
\usage{
gmwm_imu(model, data, compute.v = "fast", robust = F, eff = 0.6, ...)
}
\arguments{
\item{model}{A \code{ts.model} object containing one of the allowed models.}

\item{data}{A \code{matrix} or \code{data.frame} object with only column (e.g. \eqn{N \times 1}{ N x 1 }), or a \code{lts} object, or a \code{gts} object.}

\item{compute.v}{A \code{string} indicating the type of covariance matrix solver. "fast", "bootstrap", "asymp.diag", "asymp.comp", "fft"}

\item{robust}{A \code{boolean} indicating whether to use the robust computation (TRUE) or not (FALSE).}

\item{eff}{A \code{double} between 0 and 1 that indicates the efficiency.}

\item{...}{Other arguments passed to the main gmwm function}
}
\value{
A \code{gmwm} object with the structure:
\itemize{
 \item{estimate}{Estimated Parameters Values from the GMWM Procedure}
 \item{init.guess}{Initial Starting Values given to the Optimization Algorithm}
 \item{wv.empir}{The data's empirical wavelet variance}
 \item{ci_low}{Lower Confidence Interval}
 \item{ci_high}{Upper Confidence Interval}
 \item{orgV}{Original V matrix}
 \item{V}{Updated V matrix (if bootstrapped)}
 \item{omega}{The V matrix inversed}
 \item{obj.fun}{Value of the objective function at Estimated Parameter Values}
 \item{theo}{Summed Theoretical Wavelet Variance}
 \item{decomp.theo}{Decomposed Theoretical Wavelet Variance by Process}
 \item{scales}{Scales of the GMWM Object}
 \item{robust}{Indicates if parameter estimation was done under robust or classical}
 \item{eff}{Level of efficiency of robust estimation}
 \item{model.type}{Models being guessed}
 \item{compute.v}{Type of V matrix computation}
 \item{augmented}{Indicates moments have been augmented}
 \item{alpha}{Alpha level used to generate confidence intervals}
 \item{expect.diff}{Mean of the First Difference of the Signal}
 \item{N}{Length of the Signal}
 \item{G}{Number of Guesses Performed}
 \item{H}{Number of Bootstrap replications}
 \item{K}{Number of V matrix bootstraps}
 \item{model}{\code{ts.model} supplied to gmwm}
 \item{model.hat}{A new value of \code{ts.model} object supplied to gmwm}
 \item{starting}{Indicates whether the procedure used the initial guessing approach}
 \item{seed}{Randomization seed used to generate the guessing values}
 \item{freq}{Frequency of data}
}
}
\description{
Performs the GMWM estimation procedure using a parameter transform and sampling
scheme specific to IMUs.
}
\details{
This version of the gmwm function has customized settings
ideal for modeling with an IMU object. If you seek to model with an Gauss
Markov, \code{GM}, object. Please note results depend on the
\code{freq} specified in the data construction step within the
\code{imu}. If you wish for results to be stable but lose the
ability to interpret with respect to \code{freq}, then use
\code{AR1} terms.
}
