% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollingMax.R
\name{rollingMax}
\alias{rollingMax}
\title{Compute rolling max}
\usage{
rollingMax(mydata, length = 24)
}
\arguments{
\item{mydata}{A vector of data}

\item{length}{The length of data subset where the maximum values has
to be picked. The value must be greater or equal than 3.}
}
\value{
A numeric vector of the same length as \code{mydata}.
}
\description{
The rolling maximum value along a series of data is computed.
}
\details{
It computes the maximum value centred along a subset of data.
}
\examples{
# Compute rolling max along 24 hours on hourly time series
data(airquality)
solar.R.24 <- rollingMax(mydata = airquality$Solar.R, length = 24)

}
