% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Match&Permutation_Functions.R
\name{pmse}
\alias{pmse}
\title{Permutation invariant mean squared error}
\usage{
pmse(M1 = NULL, M2 = NULL, S1 = NULL, S2 = NULL, standardize = FALSE)
}
\arguments{
\item{M1}{Subject score 1 matrix r x n.}

\item{M2}{Subject score 2 matrix r x n.}

\item{S1}{Loading 1 with matrix p x r.}

\item{S2}{Loading 2 with matrix p x r.}

\item{standardize}{whether to standardize}
}
\value{
permutation invariant mean squared error
}
\description{
Permutation invariant mean squared error
}
\examples{
\donttest{
#get simulation data
data(exampledata)

# use JB stat to compute with singR
output_JB=singR(dX=exampledata$dX,dY=exampledata$dY,
df=0,rho_extent="small",distribution="JB",individual=TRUE)

# use pmse to measure difference from the truth
pmse(M1 = t(output_JB$est.Mj),M2 = t(exampledata$mj),standardize = TRUE)

}
}
