% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack.R
\name{get_density}
\alias{get_density}
\title{Function to get the density of points with value TRUE in the (x,y) plot}
\usage{
get_density(
  x,
  y,
  detection,
  rows.subset = 1:nrow(detection),
  high.resolution = FALSE
)
}
\arguments{
\item{x}{x-axis coordinates of cells in a 2D representation (e.g. resulting from PCA or t-SNE)}

\item{y}{y-axis coordinates of cells in a 2D representation}

\item{detection}{A logical matrix or dgRMatrix showing which gens (rows) are detected in which cells (columns)}

\item{rows.subset}{Indices of the rows of 'detection' for which to get the densities. Default: all.}

\item{high.resolution}{Logical: should high resolution be used? Default is FALSE.}
}
\value{
A 3-dimensional array (dim 1: genes/rows of expression, dim 2 and 3: x and y grid points) with density data
}
\description{
Function to get the density of points with value TRUE in the (x,y) plot
}
