% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_visualization.R
\name{plot_gene_set_haystack_raw}
\alias{plot_gene_set_haystack_raw}
\title{Visualizing the detection/expression of a set of genes in a 2D plot}
\usage{
plot_gene_set_haystack_raw(
  x,
  y,
  genes = NA,
  detection,
  high.resolution = TRUE,
  point.size = 1,
  order.by.signal = FALSE
)
}
\arguments{
\item{x}{x-axis coordinates of cells in a 2D representation (e.g. resulting from PCA or t-SNE)}

\item{y}{y-axis coordinates of cells in a 2D representation}

\item{genes}{Gene names that are present in the input expression data, or a numerical indeces. If NA, all genes will be used.}

\item{detection}{a logical matrix showing detection of genes (rows) in cells (columns)}

\item{high.resolution}{logical (default: TRUE). If set to FALSE, the density plot will be of a lower resolution}

\item{point.size}{numerical value to set size of points in plot. Default is 1.}

\item{order.by.signal}{If TRUE, cells with higher signal will be put on the foreground in the plot. Default is FALSE.}
}
\value{
A plot
}
\description{
Visualizing the detection/expression of a set of genes in a 2D plot
}
