% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_silico_system.R
\name{removeComplex}
\alias{removeComplex}
\title{Removes a regulatory complex from the in silico system.}
\usage{
removeComplex(insilicosystem, name)
}
\arguments{
\item{insilicosystem}{The in silico system (see \code{\link{createInSilicoSystem}}).}

\item{name}{Character. The name of the regulatory complex to remove.}
}
\value{
The modified in silico system.
}
\description{
Removes a regulatory complex from the in silico system. Any edge involving this complex is removed from the system.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 10, PC.p = 1, PC.TC.p = 1, regcomplexes.p = 0.8)
mysystem$complexes
mysystem$edg
mysystem2 = removeComplex(mysystem, "CTC1")
mysystem2$complexes
mysystem2$edg
}
}
