% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdLMS.R
\name{pdLMS}
\alias{pdLMS}
\title{Plot frequency distributions(s) for given L, M and S values in LMS method}
\usage{
pdLMS(
  L = 1,
  M = 1,
  S = 0.2,
  zcent = NULL,
  zlim = 3.5,
  N = 1000,
  plot = TRUE,
  ...
)
}
\arguments{
\item{L}{vector of Box-Cox transformation (lambda) values, L in the LMS
method (default 1 corresponding to the Normal distribution).}

\item{M}{vector of medians (mu), M in the LMS method (default 1).}

\item{S}{vector of coefficients of variation (sigma), S in the LMS method
(default 0.2).}

\item{zcent}{optional vector of z-scores for conversion to the measurement
scale under each distribution.}

\item{zlim}{scalar defining z-score limits underlying x-axis (default 3.5).}

\item{N}{number of points per distribution curve (default 1000).}

\item{plot}{logical for plotting (default TRUE).}

\item{\dots}{Further graphical parameters (see \code{\link{par}}) may also
be supplied as arguments, particularly colour \code{col}, line type \code{lty},
line width \code{lwd} and character \code{pch}.}
}
\value{
An invisible list with the following components:
\item{x}{vector of x values for plotting.}
\item{density}{matrix of densities for each distribution.}
\item{centile}{matrix of measurement centiles corresponding to \code{zcent}
under each distribution.}
The distributions can be plotted with \code{matplot(x, density, type='l')}.
}
\description{
The LMS method defines frequency distributions in terms of L, M and S parameters.
\code{pdLMS} plots one or more LMS distributions and optionally returns specified
centiles on each distribution.
}
\details{
L, M and S should all be the same length, recycled if necessary.
}
\examples{

## plot normal distribution
pdLMS()
## compare variety of distributions
## with centiles corresponding to +3 z-scores
pdLMS(L=-2:3, M=2:3, S=1:3/10, zcent=3, lty=1)

}
\seealso{
\code{\link{z2cent}}, \code{\link{LMS2z}}, \code{\link{cLMS}}
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
\keyword{arith}
