% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_predictors.R
\name{sits_pred_normalize}
\alias{sits_pred_normalize}
\title{Normalize predictor values}
\usage{
sits_pred_normalize(pred, stats)
}
\arguments{
\item{pred}{X-Y predictors: a data.table with one row per sample.}

\item{stats}{The output of the "sits_stats" function applied to the samples.}
}
\value{
A normalized set of predictor values
}
\description{
Most machine learning algorithms require data to be
normalized. This applies to the "SVM" method and to all deep learning ones.
To normalize the predictors, it is required that the statistics per band
for each sample have been obtained by the "sits_stats" function.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
     summary(samples_modis_ndvi)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
