% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_cluster.R
\name{sits_cluster_dendro}
\alias{sits_cluster_dendro}
\title{Find clusters in time series samples}
\usage{
sits_cluster_dendro(
  samples = NULL,
  bands = NULL,
  dist_method = "dtw_basic",
  linkage = "ward.D2",
  k = NULL,
  color_palette = "RdYlGn",
  .plot = TRUE,
  ...
)
}
\arguments{
\item{samples}{Tibble with input set of time series.}

\item{bands}{Bands to be used in the clustering.}

\item{dist_method}{Distance method.}

\item{linkage}{Agglomeration method.
Can be any `hclust` method (see `hclust`).
Default is 'ward.D2'.}

\item{k}{Desired number of clusters (overrides default value)}

\item{color_palette}{Color palette as per `grDevices::hcl.pals()` function.}

\item{.plot}{Plot the dendrogram?}

\item{...}{Additional parameters to be passed
to dtwclust::tsclust() function.}
}
\value{
Tibble with added "cluster" column.
}
\description{
These functions support hierarchical agglomerative clustering in
sits. They provide support from creating a dendrogram and using it for
cleaning samples.

\code{sits_cluster_dendro()} takes a tibble containing time series and
produces a sits tibble with an added "cluster" column. The function first
calculates a dendrogram and obtains a validity index for best clustering
using the adjusted Rand Index. After cutting the dendrogram using the chosen
validity index, it assigns a cluster to each sample.

\code{sits_cluster_frequency()} computes the contingency table between labels
and clusters and produces a matrix.
It needs as input a tibble produced by \code{sits_cluster_dendro()}.

\code{sits_cluster_clean()} takes a tibble with time series
that has an additional `cluster` produced by \code{sits_cluster_dendro()}
and removes labels that are minority in each cluster.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    clusters <- sits_cluster_dendro(cerrado_2classes)
}

}
\references{
"dtwclust" package (https://CRAN.R-project.org/package=dtwclust)
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
