% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_summary.R
\name{summary.sits_area_accuracy}
\alias{summary.sits_area_accuracy}
\title{Summarize accuracy matrix for area data}
\usage{
\method{summary}{sits_area_accuracy}(object, ...)
}
\arguments{
\item{object}{Object of classe "sits_accuracy".}

\item{...}{Further specifications for \link{summary}.}
}
\value{
A summary of the sample accuracy
}
\description{
This is a generic function. Parameters depend on the specific
type of input.
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # label the probability cube
    label_cube <- sits_label_classification(
        probs_cube,
        output_dir = tempdir()
    )
    # obtain the ground truth for accuracy assessment
    ground_truth <- system.file("extdata/samples/samples_sinop_crop.csv",
        package = "sits"
    )
    # make accuracy assessment
    as <- sits_accuracy(label_cube, validation = ground_truth)
    summary(as)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
