% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_predictors.R
\name{sits_pred_normalize}
\alias{sits_pred_normalize}
\title{Normalize predictor values}
\usage{
sits_pred_normalize(pred, stats)
}
\arguments{
\item{pred}{X-Y predictors: a data.frame with one row per sample.}

\item{stats}{Values of time series for Q02 and Q98 of the data
(list of numeric values with two elements)}
}
\value{
A data.frame with normalized predictor values
}
\description{
Most machine learning algorithms require data to be
normalized. This applies to the "SVM" method and to all deep learning ones.
To normalize the predictors, it is required that the statistics per band
for each sample have been obtained by the "sits_stats" function.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    stats <- sits_stats(samples_modis_ndvi)
    pred <- sits_predictors(samples_modis_ndvi)
    pred_norm <- sits_pred_normalize(pred, stats)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
