% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_filters.R
\name{sits_filter}
\alias{sits_filter}
\title{Filter time series with smoothing filter}
\usage{
sits_filter(data, filter = sits_whittaker())
}
\arguments{
\item{data}{Time series (tibble of class "sits") or matrix.}

\item{filter}{Filter function to be applied.}
}
\value{
Filtered time series
}
\description{
Applies a filter to all bands, using a filter function
 such as sits_whittaker() or sits_sgolay().
}
\examples{
if (sits_run_examples()) {
    # Retrieve a time series with values of NDVI
    point_ndvi <- sits_select(point_mt_6bands, bands = "NDVI")
    # Filter the point using the Whittaker smoother
    point_whit <- sits_filter(point_ndvi, sits_whittaker(lambda = 3.0))
    # Merge time series
    point_ndvi <- sits_merge(point_ndvi, point_whit,
                             suffix = c("", ".WHIT"))
    # Plot the two points to see the smoothing effect
    plot(point_ndvi)
}
}
