% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_sex_semanaepi}
\alias{plot_sex_semanaepi}
\title{Generar gráfico de distribución de casos por sexo y semana
epidemiológica}
\usage{
plot_sex_semanaepi(
  data_agrupada,
  col_sex = "sexo",
  col_semanaepi = "semana",
  fuente_data = NULL
)
}
\arguments{
\item{data_agrupada}{Un `data.frame` que contiene los datos de la enfermedad
o evento agrupados.}

\item{col_sex}{Un `character` (cadena de caracteres) con el nombre de la
columna que contiene el sexo en los datos agrupados de la enfermedad o
evento; su valor por defecto es `"sexo"`.}

\item{col_semanaepi}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene las semanas epidemiológicas en los datos agrupados
de la enfermedad o evento; su valor por defecto es `"semana"`.}

\item{fuente_data}{Un `character` (cadena de caracteres) que contiene la
leyenda o fuente de información de los datos; su valor por defecto
es `NULL`.}
}
\value{
Un `plot` o gráfico de distribución de casos por sexo y semana
epidemiológica.
}
\description{
Función que genera un gráfico de distribución de casos por sexo
y semana epidemiológica.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(dengue2020)
data_agrupada <- agrupar_sex_semanaepi(data_event = data_limpia)
plot_sex_semanaepi(
  data_agrupada = data_agrupada,
  col_sex = "sexo",
  col_semanaepi = "semana"
)
}
